IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_IdentifDNI') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_IdentifDNI
END
GO

CREATE FUNCTION [dbo].[CF_IdentifDNI](@pDato VARCHAR(100))
RETURNS INT
AS
BEGIN

DECLARE @Id_Cliente					INT
DECLARE @Flag_Tipo_DNI				TINYINT
DECLARE @Flag_Formato_Valido_Doc	INT=0
DECLARE @Doc_Escaneado				VARCHAR(20)
DECLARE @Doc_Nro					BIGINT
DECLARE @Long_Dato					INT
DECLARE @Flag_Es_Numerico			TINYINT

SET @Long_Dato			= LEN(@pDato)
SET @Flag_Es_Numerico	= dbo.CF_IsNumeric(@pDato)

IF(ISNULL(@pDato, '') = '')
BEGIN
	SET @Id_Cliente = 0
	RETURN @Id_Cliente
END

IF(@Long_Dato > 50)
BEGIN
	IF(ISNULL(dbo.SF_CortarCadena(@pDato, '"', 4), '') IN ('F', 'M') 
			OR ISNULL(dbo.SF_CortarCadena(@pDato, '"', 9), '') 	IN ('F', 'M') 
			OR ISNULL(dbo.SF_CortarCadena(@pDato, '@', 4), '') 	IN ('F', 'M') 
			OR ISNULL(dbo.SF_CortarCadena(@pDato, '@', 9), '') IN ('F', 'M'))
	BEGIN
		IF(ISNULL(dbo.SF_CortarCadena(@pDato, '"', 4), '') IN ('F', 'M') 
			OR ISNULL(dbo.SF_CortarCadena(@pDato, '@', 4), '') IN ('F', 'M'))
		BEGIN
			SET @Flag_Tipo_DNI = 1 /*Formato Nuevo*/
		END
		ELSE
		BEGIN
			SET @Flag_Tipo_DNI = 2 /*Formato Viejo*/
		END
	END
	ELSE
	BEGIN
		/*Formato NO valido*/
		SET @Flag_Tipo_DNI = 0
	END

	/*Formato Nuevo*/
	IF(@Flag_Tipo_DNI = 1) 
	BEGIN
		SET @Doc_Escaneado				= (SELECT ISNULL(dbo.SF_CortarCadena(@pDato, '"', 5),''))
		
		IF(@Doc_Escaneado = '')
		BEGIN
			SET @Doc_Escaneado			= (SELECT ISNULL(dbo.SF_CortarCadena(@pDato, '@', 5),''))
		END
		
		SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'M', '')
		SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'F', '')
		SET @Flag_Formato_Valido_Doc	= (SELECT ISNUMERIC(@Doc_Escaneado))
	END

	/*Formato Viejo*/
	IF(@Flag_Tipo_DNI = 2) 
	BEGIN
		SET @Doc_Escaneado				= (SELECT dbo.SF_CortarCadena(@pDato, '"', 2))
		SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'M', '')
		SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'F', '')
		SET @Flag_Formato_Valido_Doc	= (SELECT ISNUMERIC(@Doc_Escaneado))
	END


	IF(@Flag_Formato_Valido_Doc = 1)
	BEGIN
		SET @Doc_Nro					= @Doc_Escaneado
		SET @Id_Cliente					= (SELECT TOP 1 ISNULL(Id_Cliente, 0) 
												FROM Clientes C
													JOIN Clientes_Tipos T ON C.Id_Tipo_Cli = T.Id_Tipo_Cli
												WHERE Doc_Nro = @Doc_Nro 
												ORDER BY 
														 C.Activo DESC,
													  CASE T.Flag_Tipo
														WHEN 'P' THEN 1
														WHEN 'S' THEN 2
														WHEN ''  THEN 3
														WHEN 'N' THEN 4
														ELSE 5
													  END,
														 C.Ult_Cuota_Paga DESC
											)
	END
	ELSE
	BEGIN
		SET @Id_Cliente = 0
	END



	/*Formato NO valido*/
	IF(@Flag_Tipo_DNI = 0) 
	BEGIN
		SET @Id_Cliente = 0
	END
	
END


RETURN @Id_Cliente

END